require( "quest/purse/convout.lua" );
combine_speech_tables();

currentDepth = 0;
moving_actor = nil;
items_found = 0;
globalFlo = nil;
item_upscale = 1.15;

function found_phone(actor)
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene.PHONE_RING2:Expire();
	clear_item_meshes();
	scene:Spawn(phone_spec);
	actor:Expire();
end

function found_phoneSig(actor)
	globalFlo:SetMode(MODE.CUTSCENE);
	game:Set("found_phoneSig", 1);
	clear_item_meshes();
	
	for i=1,3 do
		actor:SetTint( { r = 0.5, g = 0.5, b = 0.5, a = 1 } );
		delay(5);
		actor:SetTint( { r = 1, g = 1, b = 1, a = 1 } );
		delay(5);
	end
	
	run_super_conversation( globalFlo, "help_signature_phone");	
	globalFlo:SetMode(MODE.FOLLOWCLICKS);
	scene:ReturnFromScene();
end

function found_key(actor)
	globalFlo:SetMode(MODE.CUTSCENE);
	game:Set("found_apartment_key", 1);
	clear_item_meshes();
	
	for i=1,3 do
		actor:SetTint( { r = 0.5, g = 0.5, b = 0.5, a = 1 } );
		delay(5);
		actor:SetTint( { r = 1, g = 1, b = 1, a = 1 } );
		delay(5);
	end
	
	scene:ReturnFromScene();
end

function found_note(actor)
	scene.FLO:SetMode(MODE.CUTSCENE);
	items_found = items_found + 1;
	
	local flashFrequency = 10;
	local flashTime = 40;
	local timer = 0;
	
	sfx:PlaySFX("audio/sfx/cookies_money");
	
	-- flash
	while timer < flashTime do
		if halo then
			actor:LoadImage("purse_item_01");
			halo = false;
		else
			actor:LoadImage("purse_item_01_halo");
			halo = true;
		end
		
		timer = timer + flashFrequency;
		delay(flashFrequency);
	end
	
	if items_found == 2 then
		game:Set("found_ten_dollars_in_purse", 1);
		help_panel_say_raw(scene:grabstring("purse_help_ten_dollars_found_two"));
		clear_item_meshes();
		delay(30);
		coroutine.yield(RESUME.ON_CLICK);
		scene.FLO:StartProc(go_back);
	else
		help_panel_say_raw(scene:grabstring("purse_help_ten_dollars_found_one"));
		game:Set("found_target_purse_item", 0);
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	end
	actor:Expire();
end

phone_info =
{
	-- small purse phone
	start_pos = { x = 480, y = 130 },
	start_scale = 0.25,
	
	-- big purse phone
	end_pos = { x = 275, y = 5 },
	end_scale = 1,
	
	-- buttons relative to phone
	button_grid_start = { x = 37, y = 317 },
	button_grid_width = 3,
	button_grid_total = 12,
	button_grid_spacing = { x = 70, y = 25 },
}

phone2_info =
{
	-- small purse phone
	start_pos = { x = 200, y = 300 },
	start_scale = 0.25,
	
	-- big purse phone
	end_pos = { x = 275, y = 5 },
	end_scale = 1,
	
	-- buttons relative to phone
	button_grid_start = { x = 37, y = 317 },
	button_grid_width = 3,
	button_grid_total = 12,
	button_grid_spacing = { x = 70, y = 25 },
}

-- purse items for various levels
local items = 
{
	level_one = 
	{
		items = 
		{
			{ image = "purse_item_01",			depth = 5, 	target = false, x = 120, y = 125, scale = 0.6},
			{ image = "purse_item_02",			depth = 4,	target = false, x = 200, y = 325 },
			{ image = "purse_item_03",			depth = 3,	target = false, x = 270, y = 90 },
			{ image = "purse_item_04",			depth = 2,	target = false, x = 430, y = 100 },
			{ image = "purse_item_05",			depth = 6,	target = false, x = 295, y = 115 },
			{ image = "purse_item_06",			depth = 7,	target = false, x = 260, y = 140 },
			{ image = "purse_item_08",			depth = 9,	target = false, x = 210, y = 280 },
			{ image = "purse_item_09",			depth = 10,	target = false, x = 580, y = 135 },
			{ image = "purse_item_10",			depth = 11,	target = false, x = 175, y = 95 },
			{ image = "purse_item_11",			depth = 32,	target = false, x = 300, y = 270 },
			{ image = "purse_item_12",			depth = 13,	target = false, x = 500, y = 330 },
			{ image = "purse_item_13",			depth = 14,	target = false, x = 640, y = 280 },
			{ image = "purse_item_14",			depth = 15,	target = false, x = 280, y = 140 },
			{ image = "purse_item_15",			depth = 16,	target = false, x = 200, y = 200 },
			{ image = "purse_item_16",			depth = 17,	target = false, x = 490, y = 425 },
			{ image = "purse_item_17",			depth = 9,	target = false, x = 540, y = 165 },
			{ image = "purse_item_18",			depth = 19,	target = false, x = 150, y = 155 },
			{ image = "purse_item_19",			depth = 20,	target = false, x = 510, y = 275},
			{ image = "purse_item_20",			depth = 21,	target = false, x = 470, y = 105 },
			{ image = "purse_item_21",			depth = 22,	target = false, x = 215, y = 375 },
			{ image = "purse_item_22",			depth = 23,	target = false, x = 460, y = 165 },
			{ image = "purse_item_23",			depth = 24,	target = false, x = 330, y = 410 },
			{ image = "purse_item_24",			depth = 25,	target = false, x = 590, y = 375 },
			{ image = "purse_item_25",			depth = 26,	target = false, x = 110, y = 355 },
			{ image = "purse_item_26",			depth = 27,	target = false, x = 335, y = 90 },
			{ image = "purse_item_27",			depth = 28,	target = false, x = 115, y = 200 },
			{ image = "purse_item_28",			depth = 29,	target = false, x = 430, y = 110 },
			{ image = "purse_item_29",			depth = 30,	target = false, x = 165, y = 265},
			{ image = "purse_item_30",			depth = 31,	target = false, x = 365, y = 285 },
			{ image = "purse_item_31",			depth = 8,	target = false, x = 530, y = 290 },
			{ image = "purse_item_32",			depth = 5,	target = false, x = 580, y = 85 },
			{ image = "purse_item_33",			depth = 6,	target = false, x = 140, y = 100 },

			{ image = "phone",				depth = 1,	target = true, x = phone_info.start_pos.x, y = phone_info.start_pos.y, scale = phone_info.start_scale, foundProc = found_phone},
		};
		help_text = "help_diner_purse";
	};
	
	level_two = 
	{
		items = 
		{
			{ image = "purse_item_03",			depth = 8,	target = false, x = 285, y = 416 },
			{ image = "purse_item_04",			depth = 16,	target = false, x = 314, y = 387 },
			{ image = "purse_item_05",			depth = 10,	target = false, x = 606, y = 101 },
			{ image = "purse_item_06",			depth = 32,	target = false, x = 172, y = 372 },
			{ image = "purse_item_07",			depth = 7,	target = false, x = 389, y = 314 },
			{ image = "purse_item_08",			depth = 14,	target = false, x = 554, y = 343 },
			{ image = "purse_item_09",			depth = 15,	target = false, x = 437, y = 152 },
			{ image = "purse_item_10",			depth = 12,	target = false, x = 450, y = 247 },
			{ image = "purse_item_11",			depth = 20,	target = false, x = 142, y = 217 },
			{ image = "purse_item_12",			depth = 25,	target = false, x = 109, y = 339 },
			{ image = "purse_item_13",			depth = 6,	target = false, x = 552, y = 285 },
			{ image = "purse_item_14",			depth = 5,	target = false, x = 301, y = 120 },
			{ image = "purse_item_15",			depth = 11,	target = false, x = 594, y = 130 },
			{ image = "purse_item_16",			depth = 4,	target = false, x = 380, y = 278 },
			{ image = "purse_item_17",			depth = 3,	target = false, x = 467, y = 314 },
			{ image = "purse_item_18",			depth = 17,	target = false, x = 540, y = 194 },
			{ image = "purse_item_19",			depth = 31,	target = false, x = 578, y = 317},
			{ image = "purse_item_20",			depth = 30,	target = false, x = 293, y = 232 },
			{ image = "purse_item_21",			depth = 29,	target = false, x = 262, y = 86 },
			{ image = "purse_item_22",			depth = 24,	target = false, x = 125, y = 274 },
			{ image = "purse_item_23",			depth = 28,	target = false, x = 325, y = 317 },
			{ image = "purse_item_24",			depth = 27,	target = false, x = 157, y = 403 },
			{ image = "purse_item_25",			depth = 6,	target = false, x = 554, y = 211 },
			{ image = "purse_item_26",			depth = 26,	target = false, x = 430, y = 90 },
			{ image = "purse_item_27",			depth = 23,	target = false, x = 477, y = 139 },
			{ image = "purse_item_28",			depth = 9,	target = false, x = 420, y = 273 },
			{ image = "purse_item_29",			depth = 22,	target = false, x = 117, y = 92},
			{ image = "purse_item_30",			depth = 13,	target = false, x = 176, y = 86 },
			{ image = "purse_item_31",			depth = 21,	target = false, x = 495, y = 75 },
			{ image = "purse_item_32",			depth = 18,	target = false, x = 202, y = 267 },
			{ image = "purse_item_33",			depth = 19,	target = false, x = 206, y = 242 },
			
			{ image = "purse_item_01",			depth = 1,		target = true, x = 155, y = 257, foundProc = found_note, scale = 0.5},
			{ image = "purse_item_01",			depth = 2,		target = true, x = 435, y = 321, foundProc = found_note, scale = 0.5},
		};
		help_text = "purse_help_ten_dollars";
	};  

	level_three = 
	{
		items = 
		{
			{ image = "purse_item_01",			depth = 5, 	target = false, x = 120, y = 125, scale = 0.6},
			{ image = "purse_item_02",			depth = 4,	target = false, x = 200, y = 325 },
			{ image = "purse_item_03",			depth = 3,	target = false, x = 270, y = 90 },
			{ image = "purse_item_04",			depth = 2,	target = false, x = 430, y = 100 },
			{ image = "purse_item_05",			depth = 6,	target = false, x = 295, y = 115 },
			{ image = "purse_item_06",			depth = 7,	target = false, x = 260, y = 140 },
			{ image = "purse_item_08",			depth = 9,	target = false, x = 228, y = 264 },
			{ image = "purse_item_09",			depth = 10,	target = false, x = 580, y = 135 },
			{ image = "purse_item_10",			depth = 11,	target = false, x = 175, y = 95 },
			{ image = "purse_item_11",			depth = 32,	target = false, x = 290, y = 221 },
			{ image = "purse_item_12",			depth = 13,	target = false, x = 500, y = 330 },
			{ image = "purse_item_13",			depth = 14,	target = false, x = 640, y = 280 },
			{ image = "purse_item_14",			depth = 15,	target = false, x = 140, y = 280 },
			{ image = "purse_item_15",			depth = 16,	target = false, x = 460, y = 218 },
			{ image = "purse_item_16",			depth = 17,	target = false, x = 490, y = 425 },
			{ image = "purse_item_17",			depth = 9,	target = false, x = 540, y = 165 },
			{ image = "purse_item_18",			depth = 19,	target = false, x = 150, y = 155 },
			{ image = "purse_item_19",			depth = 20,	target = false, x = 510, y = 275},
			{ image = "purse_item_20",			depth = 21,	target = false, x = 470, y = 105 },
			{ image = "purse_item_21",			depth = 22,	target = false, x = 215, y = 375 },
			{ image = "purse_item_22",			depth = 23,	target = false, x = 460, y = 165 },
			{ image = "purse_item_23",			depth = 24,	target = false, x = 330, y = 410 },
			{ image = "purse_item_24",			depth = 25,	target = false, x = 590, y = 375 },
			{ image = "purse_item_25",			depth = 26,	target = false, x = 110, y = 355 },
			{ image = "purse_item_26",			depth = 27,	target = false, x = 335, y = 90 },
			{ image = "purse_item_27",			depth = 28,	target = false, x = 115, y = 200 },
			{ image = "purse_item_28",			depth = 29,	target = false, x = 370, y = 260 },
			{ image = "purse_item_29",			depth = 30,	target = false, x = 165, y = 265},
			{ image = "purse_item_30",			depth = 31,	target = false, x = 325, y = 100 },
			{ image = "purse_item_31",			depth = 8,	target = false, x = 530, y = 290 },
			{ image = "purse_item_32",			depth = 5,	target = false, x = 580, y = 85 },
			{ image = "purse_item_33",			depth = 5,	target = false, x = 140, y = 100 },

			{ image = "phone",				depth = 1,	target = true, x = phone2_info.start_pos.x, y = phone2_info.start_pos.y, scale = phone2_info.start_scale, foundProc = found_phoneSig},
		};
		help_text = "help_signature_purse";
	};	
	level_four = 
	{
		items = 
		{
			{ image = "purse_item_01",			depth = 5, 	target = false, x = 120, y = 125, scale = 0.6},
			{ image = "purse_item_03",			depth = 8,	target = false, x = 285, y = 416 },
			{ image = "purse_item_04",			depth = 16,	target = false, x = 314, y = 387 },
			{ image = "purse_item_05",			depth = 10,	target = false, x = 606, y = 101 },
			{ image = "purse_item_06",			depth = 32,	target = false, x = 172, y = 372 },
			{ image = "purse_item_07",			depth = 7,	target = false, x = 389, y = 314 },
			{ image = "purse_item_09",			depth = 15,	target = false, x = 437, y = 152 },
			{ image = "purse_item_10",			depth = 12,	target = false, x = 450, y = 247 },
			{ image = "purse_item_11",			depth = 20,	target = false, x = 142, y = 217 },
			{ image = "purse_item_12",			depth = 25,	target = false, x = 109, y = 339 },
			{ image = "purse_item_13",			depth = 6,	target = false, x = 552, y = 285 },
			{ image = "purse_item_14",			depth = 5,	target = false, x = 115, y = 180 },
			{ image = "purse_item_15",			depth = 11,	target = false, x = 594, y = 130 },
			{ image = "purse_item_16",			depth = 4,	target = false, x = 380, y = 278 },
			{ image = "purse_item_17",			depth = 3,	target = false, x = 467, y = 314 },
			{ image = "purse_item_18",			depth = 17,	target = false, x = 540, y = 194 },
			{ image = "purse_item_19",			depth = 31,	target = false, x = 578, y = 317},
			{ image = "purse_item_20",			depth = 30,	target = false, x = 293, y = 232 },
			{ image = "purse_item_21",			depth = 29,	target = false, x = 262, y = 86 },
			{ image = "purse_item_22",			depth = 24,	target = false, x = 246, y = 128 },
			{ image = "purse_item_23",			depth = 28,	target = false, x = 325, y = 317 },
			{ image = "purse_item_24",			depth = 27,	target = false, x = 157, y = 403 },
			{ image = "purse_item_25",			depth = 6,	target = false, x = 157, y = 108 },
			{ image = "purse_item_26",			depth = 26,	target = false, x = 430, y = 90 },
			{ image = "purse_item_27",			depth = 23,	target = false, x = 477, y = 139 },
			{ image = "purse_item_28",			depth = 9,	target = false, x = 174, y = 283 },
			{ image = "purse_item_29",			depth = 22,	target = false, x = 117, y = 92},
			{ image = "purse_item_30",			depth = 13,	target = false, x = 113, y = 92 },
			{ image = "purse_item_31",			depth = 21,	target = false, x = 507, y = 92 },
			{ image = "purse_item_32",			depth = 18,	target = false, x = 202, y = 267 },
			{ image = "purse_item_33",			depth = 19,	target = false, x = 303, y = 118 },

			{ image = "purse_item_08",			depth = 1,	target = true, x = 160, y = 122, foundProc = found_key },
		};
		help_text = "help_key_purse";
	};	
};

active_items = {};

function get_purse_item_spec(_name, _data)
	return
	{
		name = _name;
		halo = _data.image;
		gfx = { image = _data.image };
		
		command = function(actor)
			actor:SetDepthValue(_data.depth);
			actor:JumpToPoint { x = _data.x, y = _data.y };
			actor:SetPointAtCursor("cursor_open_hand");
			actor.moving = false;
			actor.foundProc = _data.foundProc;
			
			if _data.scale then
				actor:SetScale(_data.scale);
			end
			
			actor.data = _data;
			
			if _data.target then
				actor.on_click = function(flo, purse_item)					
					game:Set("found_target_purse_item", 1);
					actor:SetDepthValue(currentDepth);
					currentDepth = currentDepth + 1;
					globalFlo = flo;
					purse_item:StartProc(actor.foundProc);										
					return RESPONSE.IGNORE;
				end;
			else
				actor.on_click = function(flo, purse_item)
					--actor.hotspot = { x = 50, y = 50 };
					if game:Get("found_target_purse_item") == 0 then
						if actor.moving == false then
							local clickedAt = scene:GetClickedAtScreen();
							local actorPos = actor:GetPosition();
							actor.moving = true;
							actor.movingx = actorPos.x - clickedAt.x;
							actor.movingy = actorPos.y - clickedAt.y ;
							actor:SetDepthValue(currentDepth);
							currentDepth = currentDepth + 1;
							actor:StartProc(move_item);
							moving_actor = actor;
							actor:SetPointAtCursor("cursor_closed_hand");
							scene.GAME_CONTROLLER:StartProc(moving_item);
							sfx:PlaySFX("audio/sfx/pickup_item.ogg");
							actor:LoadZone("over_actor");
						end
					end
					return RESPONSE.IGNORE;
				end;
				
				--actor.on_release = function(flo, purse_item)
				--	actor.moving = false;
				--	return RESPONSE.IGNORE;
				--end;
				
				actor.point_at_fn = function(flo, enter)
					local scalemod = 1;
					local upscale = item_upscale;
					
					if _data.scale then
						scalemod = _data.scale;
						upscale = upscale * scalemod;
					end
					
					if (moving_actor == nil or actor == moving_actor) and game:Get("found_target_purse_item") == 0 then
						if enter then
							local image_size1 = actor:GetImageSize();
							image_size1.x = image_size1.x * scalemod;
							image_size1.y = image_size1.y * scalemod;
							--image_size1.x = image_size1.x * activity_data.scale;
							--image_size1.y = image_size1.y * activity_data.scale;
							actor:SetScale(upscale);
							--sfx:PlaySFX("audio/sfx/sfx_typing_03.ogg");
							local image_size2 = actor:GetImageSize();
							image_size2.x = image_size2.x * (upscale);
							image_size2.y = image_size2.y * (upscale);
							
							local newPosition = actor:GetPosition();
							newPosition.x = newPosition.x - ((image_size2.x - image_size1.x) / 2);
							newPosition.y = newPosition.y - ((image_size2.y - image_size1.y) / 2);
							actor:JumpToPoint(newPosition);
						else
							local image_size1 = actor:GetImageSize();
							image_size1.x = image_size1.x * (upscale);
							image_size1.y = image_size1.y * (upscale);
							actor:SetScale(scalemod);
							local image_size2 = actor:GetImageSize();
							image_size2.x = image_size2.x * scalemod;
							image_size2.y = image_size2.y * scalemod;
							
							local newPosition = actor:GetPosition();
							newPosition.x = newPosition.x - ((image_size2.x - image_size1.x) / 2);
							newPosition.y = newPosition.y - ((image_size2.y - image_size1.y) / 2);
							actor:JumpToPoint(newPosition);
							--sfx:PlaySFX("audio/sfx/sfx_typing_02.ogg");
						end
					end
				end;
			end
		end;
	}
end

function spawn_purse_items(actor)
	for i,v in pairs(items) do
		if tostring(i) == game:GetString("purse_level") then
			for j,w in pairs(v.items) do
				local purse_item_spec = get_purse_item_spec(tostring(j), w);
				if currentDepth <= w.depth then
					currentDepth = w.depth + 1;
				end
				local purse_item = scene:Spawn(purse_item_spec);
				if not w.target then
					table.insert(active_items, purse_item);
				end
				
			end
			
			help_panel_say_raw(scene:grabstring(v.help_text));
		end
	end
	
	if game:GetString("purse_level") == "level_one" then -- purse
		scene:Spawn(phone_ring_spec2);
	end;
end

function clear_item_meshes()
	for i,v in pairs(active_items) do
		if v then
			v:DumpZone();
		end
	end
end

game_controller_spec = 
{
	name = "GAME_CONTROLLER";
}

flo_spec =
{
	name = "FLO";

	command = function(actor)
		actor:ModifySaySpec(flo_text_spec)
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function move_item(actor)
	while actor.moving do
		local cursorPos = scene:GetCursorPos();
		local newPoint = { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };
		newPoint.x = math.min(math.max(0, newPoint.x), 800-actor:GetImageSize().x);
		newPoint.y = math.min(math.max(0, newPoint.y), 500-actor:GetImageSize().y);
		actor:JumpToPoint(newPoint);
		coroutine.yield(RESUME.NOW);
	end
end

-- running as GAME_CONTROLLER proc whilst actor is moving
function moving_item(actor)
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene.FLO:SetMode(MODE.CUTSCENE);
	coroutine.yield(RESUME.NOW);
	
	-- if we didn't click on another clothing item, put us back
	stop_moving();
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

function stop_moving()
	-- if we didn't click on another clothing item, put us back
	if moving_actor ~= nil then
		moving_actor:LoadZone(moving_actor.data.image);
		moving_actor.moving = false;
		moving_actor:SetPointAtCursor("cursor_open_hand");
		moving_actor = nil;
		sfx:PlaySFX("audio/sfx/drop_item.ogg");
	end;
end

phone_spec = 
{
	name = "PHONE";
	--halo = "phone";
	gfx = { image = "phone" };
	
	command = function(actor)
		actor:SetDepthValue(currentDepth);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 1, b = 0 },
			y = 70,
			x = 50,
			w = 190,
			h = 260,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
		};
		
		local cur_scale = phone_info.start_scale;
		local cur_pos = phone_info.start_pos;
		
		actor:JumpToPoint(cur_pos);
		actor:SetScale(cur_scale);
		
		for i=1,3 do
			actor:SetTint( { r = 0.5, g = 0.5, b = 0.5, a = 1 } );
			delay(5);
			actor:SetTint( { r = 1, g = 1, b = 1, a = 1 } );
			delay(5);
		end
		
		local scale_time = 20;
		local counter = 0;
		local des_scale = phone_info.end_scale;
		local des_pos = phone_info.end_pos;
		
		while counter < scale_time do
			local delta = counter / scale_time;
			local scale = cur_scale + ( (des_scale - cur_scale) * delta );
			local pos = { x = 0, y = 0 };
			pos.x = cur_pos.x + ( (des_pos.x - cur_pos.x) * delta );
			pos.y = cur_pos.y + ( (des_pos.y - cur_pos.y) * delta );
			
			actor:JumpToPoint(pos);
			actor:SetScale(scale);
			
			counter = counter + 1;
			delay(1);
		end
		
		actor:JumpToPoint(des_pos);
		actor:SetScale(des_scale);
		
		actor:SayRaw(scene:grabstring("text_message_from_quinn"));
		
		help_panel_say_raw(scene:grabstring("help_diner_phone"));
		scene:Spawn(target_phone_button_spec);
		spawn_phone_buttons();
	end;
};

target_phone_button_spec = 
{
	name = "TARGET_PHONE_BUTTON";
	halo = "phone_button";
	gfx = { image = "phone_button_up" };
	
	command = function(actor)
		--actor:SetDepthValue( DEPTH.DEPTH_FRONTMOST );
		--actor:SetAlpha(0);
		actor:JumpToNamedPoint("phone_button");
		actor:JumpToPoint(scene.PHONE:GetPosition());
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor:LoadImage("phone_button_highlight");
		else
			actor:LoadImage("phone_button_up");
		end;
	end;
	
	on_click = function(flo, phone)
		phone:LoadImage("phone_button_down");
		sfx:PlaySFX("audio/sfx/button_beep.ogg");
	end;
	
	on_release = function(flo, phone)
		phone:LoadImage("phone_button_up");
		game:Set("found_phone", 1);
		flo:StartProc(go_back);
	end;
}

function spawn_phone_button(_position, _button_num)
	scene:Spawn
	{
		name = "PHONE_BUTTON_" .. _button_num;
		
		command = function(actor)
			actor:JumpToPoint(_position);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				x = 0,
				y = 11,
				w = 65,
				h = 20,
				bubble = false,
				outline_size = 0,
				lineheight = 18,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			
			actor:Say("purse_phone_" .. _button_num);
		end;
	}
end

function spawn_phone_buttons()
	local grid_start = 
		{
			x = phone_info.end_pos.x + phone_info.button_grid_start.x,
			y = phone_info.end_pos.y + phone_info.button_grid_start.y
		};
	for i = 0, phone_info.button_grid_total-1, 1 do
		local grid_pos = 
			{
				x = grid_start.x + (phone_info.button_grid_spacing.x * fmod(i, phone_info.button_grid_width)),
				y = grid_start.y + (phone_info.button_grid_spacing.y * math.floor(i/phone_info.button_grid_width)),
			};
		spawn_phone_button(grid_pos, i+1);
	end
end

phone_highlight = 
{
	name = "PHONE_HIGHLIGHT";
	gfx = { image = "phone" };
	
	command = function(actor)
		actor:SetDepthValue(currentDepth);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 1, b = 0 },
			y = 70,
			x = 50,
			w = 190,
			h = 260,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
		};
		
		actor:SayRaw(scene:grabstring("text_message_from_quinn"));
		
		help_panel_say_raw(scene:grabstring("help_diner_phone"));
	end;
	
	on_click = function(flo, phone)
		flo:StartProc(go_back);
	end;
};
function go_back(flo)
	raise_hud();
	scene:ReturnFromScene();
end

phone_ring_spec2 = 
{
	name = "PHONE_RING2";
	command = function(actor)
	
		while true do 
			sfx:PlaySFX("audio/sfx/phone_ring.ogg");
			delay(200);
		end
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		scene:SetCameraFollowActor(nil);
		scene:SetTextBoundsXY(20, 20);
		game:ClearInvUsage();
		
		if IsCheatMode() then
			--testing
			if game:GetString("purse_level") == "" then
				game:SetString("purse_level", "level_three");
			end
		end
		
		fade_scene_up(true);
		lower_hud();
		spawn_help_panel();
		
		game:Set("found_target_purse_item", 0);
		
		spawn_purse_items();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1",
	};
	
	bg_image = 
	{
		{ "purse", 0 },
	};
	
	ground = "background";
	
	actorlist = 
	{ 
		game_controller_spec,
		flo_spec,
		scene_setup,
	};
};
